<?php defined('SYSPATH') or die('No direct script access.');

class CheckAction extends Controller_Template {

	public $template = 'v_main';
	public $error;

	public function before(){
		$auth = Auth::instance();
		if ( ! $auth->logged_in()) {
            $continue = '';
            if ('more' == $this->request->action() || 'more_ex' == $this->request->action()) {
                $continue = '?continue=https://' . $_SERVER['HTTP_HOST'] . '/' . $this->request->uri();
            }
            HTTP::redirect('/login' . $continue);
        }

		$controller = $this->request->directory() . ($this->request->directory() ? '/' : '') . $this->request->controller();
		$action = ORM::factory('Action', array('name' => $controller));
		$action_user = ORM::factory('Action', $action->id);

        /* Clear main filter if go another page */
		if($controller != 'Logpost' && Session::instance()->get('filter') != null){
			Session::instance()->delete('filter');
		}

		$roles = $auth->get_user()->roles->find_all();
		foreach($roles as $key => $role){
			if($role->has('actions', $action_user)){
				return parent::before();
            }elseif ('more' == $this->request->action() && $role->has('actions', ORM::factory('Action', ['name' => 'Logpost/More']))
                || 'mini' == $this->request->action() && $role->has('actions', ORM::factory('Action', ['name' => 'Logpost/Mini']))
                || 'more_ex' == $this->request->action() && $role->has('actions', ORM::factory('Action', ['name' => 'Logpost/More_ex']))) {
                return Controller_Template::before();
			}elseif($key + 1 == $roles->count()){
                $roles_all = DB::select('a.name')
                    ->from(DB::expr('roles_users AS r'))
                    ->where('user_id', '=', $auth->get_user('id'))
                    ->join(DB::expr('actions_roles AS a_r'))
                    ->on('r.role_id', '=', 'a_r.role_id')
                    ->join(DB::expr('actions AS a'))
                    ->on('a_r.action_id', '=', 'a.id')
                    ->execute()
                    ->as_array();
                foreach($roles_all as $r){
                    if(!strpos($r['name'], ' ') && $r['name'] != 'Logpost/More_ex' && $r['name'] != 'Logpost/More'){
                        HTTP::redirect('/' . UTF8::strtolower($r['name']));
                    }
                }

                throw HTTP_Exception::factory(403);
			}
		}
	}

	public function after(){
		$actions = ORM::factory('Action')->find_all();
		$user = Auth::instance()->get_user();

		$this->template->navbar = View::factory('v_navbar')
			->bind('actions', $actions)
			->bind('user', $user);

		return parent::after();
	}
}